/******************************* Initial Condition*****************************

 Crystal input should be force at 12Mhz

*******************************************************************************/
#define    XTAL_12Mhz

#define    SET         1
#define    CLR         0

#define    BIT         bit
#define    BYTE        unsigned char
#define    WORD        unsigned int
#define    DWORD       unsigned long

#define    XBYTE       BYTE volatile xdata


#define    HIBYTE( V1 )     ((BYTE)((V1) >> 8))
#define    LOBYTE( V1 )     ((BYTE)((V1) & 0xFF))

/*********************************** ID ***************************************
 
 USB_VID  -> This VID is registered under Megawin Technology Co., Ltd. at USB-IF.
             Any third party needs the written approval from Megawin in order to
             use this VID.
 
*******************************************************************************/
#define    USB_VID          0xE6A
#define    USB_PID          0x30F
#define    USB_DID          0x140


#define    MF_STRING                             // Supported Manufacture String
#define    PD_STRING                             // Supported Product String
//#define    SN_STRING                             // Supported SerialNumber String


typedef struct
   { BYTE Suspend : 1;
     BYTE Reset : 1;
     BYTE WakeUp : 1;
     BYTE EmuOK : 1;
     BYTE WakeupHost : 1;
     BYTE Res5 : 1;
     BYTE Res6 : 1;
     BYTE KB_LED : 1;
   } USBEVENT;


//----- define for " Modifier " -----//
#define    L_CTRL              0x01
#define    L_SHIFT             0x02
#define    L_ALT               0x04
#define    L_GUI               0x08
#define    R_CTRL              0x10
#define    R_SHIFT             0x20
#define    R_ALT               0x30
#define    R_GUI               0x80


//----- define for " MediaKey " -----//
#define    KEY_VOLUMEUP        0x01
#define    KEY_VOLUMEDOWN      0x02
#define    KEY_VOLUMEMUTE      0x03
#define    KEY_PLAYPAUSE       0x04
#define    KEY_NEXT            0x05
#define    KEY_PREVIOUS        0x06
#define    KEY_STOP            0x07
#define    KEY_MEDIAPLAY       0x08
#define    KEY_SEARCH          0x09
#define    KEY_EMAIL           0x0A
#define    KEY_WWW             0x0B

#define    KEY_SLEEP           0x81
#define    KEY_POWER           0x82
#define    KEY_WAKEUP          0x83


//----- define for " Modifier " -----//
#define    LED_NumLock         0x01
#define    LED_Caps            0x02
#define    LED_ScrollLock      0x04